/*
 * Decompiled with CFR 0.152.
 */
package com.barion.dungeons_enhanced.structures.prefabs;

import com.barion.dungeons_enhanced.DEStructures;
import com.barion.dungeons_enhanced.structures.prefabs.DESimpleStructure;
import com.legacy.structure_gel.util.ConfigTemplates;
import com.legacy.structure_gel.worldgen.GelPlacementSettings;
import com.legacy.structure_gel.worldgen.structure.GelConfigStructure;
import com.legacy.structure_gel.worldgen.structure.GelStructureStart;
import com.legacy.structure_gel.worldgen.structure.GelTemplateStructurePiece;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class DESimpleCellarStructure
extends GelConfigStructure<NoFeatureConfig> {
    protected ResourceLocation MainPiece;
    protected ResourceLocation Cellar;
    protected BlockPos Offset;
    protected int CellarOffset;

    public DESimpleCellarStructure(String resourceTop, String resourceBottom, BlockPos offset, int cellarOffset, ConfigTemplates.StructureConfig config) {
        super(NoFeatureConfig.field_236558_a_, config);
        this.MainPiece = DEStructures.locate(resourceTop);
        this.Cellar = DEStructures.locate(resourceBottom);
        this.Offset = offset;
        this.CellarOffset = cellarOffset;
    }

    protected boolean isFeatureChunk(ChunkGenerator chunkGen, BiomeProvider biomeProvider, long seed, SharedSeedRandom sharedSeedRand, int chunkPosX, int chunkPosZ, Biome biomeIn, ChunkPos chunkPos, NoFeatureConfig config) {
        int x = chunkPosX * 16;
        int z = chunkPosZ * 16;
        int y = chunkGen.func_222529_a(x, z, Heightmap.Type.WORLD_SURFACE_WG);
        Block block = chunkGen.func_230348_a_(x, z).func_180495_p(new BlockPos(x, y - 1, z)).func_177230_c();
        if (block == Blocks.field_150355_j) {
            return false;
        }
        return super.func_230363_a_(chunkGen, biomeProvider, seed, sharedSeedRand, chunkPosX, chunkPosZ, biomeIn, chunkPos, (IFeatureConfig)config);
    }

    public Structure.IStartFactory<NoFeatureConfig> func_214557_a() {
        return (x$0, x$1, x$2, x$3, x$4, x$5) -> new Start((Structure<NoFeatureConfig>)x$0, x$1, x$2, x$3, x$4, x$5);
    }

    public void assemble(TemplateManager templateManager, BlockPos pos, Rotation rotation, List<StructurePiece> structurePieces) {
        structurePieces.add((StructurePiece)new DESimpleStructure.Piece(templateManager, this.MainPiece, pos, rotation));
    }

    public void assembleCellar(TemplateManager templateManager, BlockPos pos, Rotation rotation, List<StructurePiece> structurePieces) {
        structurePieces.add((StructurePiece)new DESimpleStructure.Piece(templateManager, this.Cellar, pos, rotation));
    }

    public static class Piece
    extends GelTemplateStructurePiece {
        public Piece(TemplateManager templateManager, ResourceLocation location, BlockPos pos, Rotation rotation, int componentType) {
            super(DEStructures.DruidCircle.getPieceType(), location, componentType);
            this.field_186178_c = pos;
            this.field_186169_c = rotation;
            this.setupTemplate(templateManager);
        }

        public Piece(TemplateManager templateManager, ResourceLocation location, BlockPos pos, Rotation rotation) {
            this(templateManager, location, pos, rotation, 0);
        }

        public Piece(TemplateManager templateManager, CompoundNBT nbtCompound) {
            super(DEStructures.DruidCircle.getPieceType(), nbtCompound);
            this.setupTemplate(templateManager);
        }

        public PlacementSettings createPlacementSettings(TemplateManager templateManager) {
            BlockPos sizePos = templateManager.func_200219_b(this.name).func_186259_a();
            BlockPos centerPos = new BlockPos(sizePos.func_177958_n() / 2, 0, sizePos.func_177952_p() / 2);
            return new GelPlacementSettings().setMaintainWater(false).func_186220_a(this.field_186169_c).func_186214_a(Mirror.NONE).func_207665_a(centerPos);
        }

        public void addProcessors(TemplateManager templateManager, PlacementSettings placementSettings) {
            super.addProcessors(templateManager, placementSettings);
        }

        protected void func_186175_a(String key, BlockPos pos, IServerWorld world, Random rnd, MutableBoundingBox bounds) {
        }
    }

    public class Start
    extends GelStructureStart<NoFeatureConfig> {
        public Start(Structure<NoFeatureConfig> structureIn, int chunkX, int chunkZ, MutableBoundingBox boundsIn, int referenceIn, long seed) {
            super(structureIn, chunkX, chunkZ, boundsIn, referenceIn, seed);
        }

        public void generatePieces(DynamicRegistries registry, ChunkGenerator chunkGen, TemplateManager templateManagerIn, int chunkX, int chunkZ, Biome biomeIn, NoFeatureConfig configIn) {
            DESimpleCellarStructure.this.setLakeProof(true);
            int x = chunkX * 16 + DESimpleCellarStructure.this.Offset.func_177958_n();
            int z = chunkZ * 16 + DESimpleCellarStructure.this.Offset.func_177952_p();
            int y = chunkGen.func_222529_a(x, z, Heightmap.Type.WORLD_SURFACE_WG) + DESimpleCellarStructure.this.Offset.func_177956_o();
            Rotation rotation = Rotation.func_222466_a((Random)this.field_214631_d);
            DESimpleCellarStructure.this.assemble(templateManagerIn, new BlockPos(x, y, z), rotation, this.field_75075_a);
            this.func_202500_a();
            DESimpleCellarStructure.this.assembleCellar(templateManagerIn, new BlockPos(x, y + DESimpleCellarStructure.this.CellarOffset, z), rotation, this.field_75075_a);
        }
    }
}

